local main_loop = loadfile("squirrelscripts/main_ai_loop.nut");
dofile("squirrelscripts/ai_functions.nut");

function init() {
	timer <- 500;
	already_in_bombardment_range <- false;
}

function check_for_planetary_bombardment_range() {
	local wakeup = true;
	foreach(squad in player_squads) {
		if (squad.get_type() == 3) {
			if (squad.get_distance(my_squads[0]) > 1200) {
				wakeup = false;
				break;
			}
		}
	}
	
	if (wakeup) {
		wakeup_mission_script(1);
		already_in_bombardment_range = true;
	}
}

function check_for_player_cap_ships_lost() {
	local num_caps = 0;
	foreach(squad in player_squads) {
		if (squad.get_type() == 3)
			++num_caps;
	}
	
	if (num_caps < 2)
		wakeup_mission_script(0);
}

function run_ai() {
	if (my_squads.len() == 1) {
		if (!already_in_bombardment_range)
			check_for_planetary_bombardment_range();
		return;
	} else {
		check_for_player_cap_ships_lost()
		check_for_launch_defence();
	}
	
	if (world_frame_counter() > timer) {
		local player_pos = is_player_squad_close("big_ship", 10500);
		//only launch attacks when they get close
		if (player_pos && world_frame_counter() > timer) {
			launch_attack_wave(player_pos, 2);
			//1 minute
			timer = world_frame_counter() + 1800;
		}
	}
}

main_loop();
